function a=STM32F103_T1_PWM(skt,chan,pre_scaler_divide_ratio,cycle_period,high_period)
% Chan 1 gives output on pin A8 (AF02)
% Chan 2 gives output on pin A9 (AF02)
% Chan 3 gives output on pin A10 (AF02)
% Chan 4 gives output on pin A11 (AF02)
% https://www.st.com/resource/en/datasheet/stm32f411ce.pdf page 47-52
%
%a=ST32F103_T1_PWM(skt,2,10000,2555)
%

  if (nargin==3) %deal with 3 parameter only call
      s=sprintf("TIM3_CCR%d",chan);
      udpset(skt,s,pre_scaler_divide_ratio);%configure the pwm - high period
      return;
  endif
if (nargin~=5)
 error("ST32F103_T1_PWM(skt,chan,pre_scaler_divide_ratio,cycle_period,high_period) needs 3 or 5 input parameters!" )  ;
endif
STM32F103_bitfields;
pin=TIM1_OC_chan1pin(chan);
  %make sure timer T1 clock is on
  %RCC_APB1ENR and ARCC_APB1RSTR bit fields
  v=bitor(udpget(skt,"RCC_APB1ENR"),TIM1EN);
  udpset(skt,"RCC_APB1ENR",v); %turn on tim1 clock
  udpset(skt,"TIM1_CR2",0);%configure the timer

%PSC Prescaler = n+1 divider
TIM1_PSC_VAL=pre_scaler_divide_ratio-1; % 100 gives 1 MHz with a 100MHz clock
udpset(skt,"TIM1_PSC",TIM1_PSC_VAL);%configure the timer
%ARR
% Auto Reload 65535 gives 65.536 mS reload period 10000-1 gives 10mS
TIM1_ARR_VAL=cycle_period-1;
udpset(skt,"TIM1_ARR",TIM1_ARR_VAL);%configure the timer

udpset(skt,"TIM1_CCER",bitand(65535-(16^(chan-1)),udpget(skt,"TIM1_CCER")));
% Now the channel specific stuff
if (chan==1)%
%CCMR1_Output
  TIM1_CCMR1_VAL=bitor((OC1PE*1)+(OC1M*6),bitand(udpget(skt,"TIM1_CCMR1"),(65535-255)));  % mode 6 pwm, preload double buffer enable
  udpset(skt,"TIM1_CCMR1",TIM1_CCMR1_VAL);%configure the timer
endif

if (chan==2)%
%CCMR1_Output
  TIM1_CCMR1_VAL=bitor((OC2PE*1)+(OC2M*6),bitand(udpget(skt,"TIM1_CCMR1"),(255)));  % mode 6 pwm, preload double buffer enable
  udpset(skt,"TIM1_CCMR1",TIM1_CCMR1_VAL);%configure the timer
endif

if (chan==3)%
%CCMR2_Output
  TIM1_CCMR2_VAL=bitor((OC1PE*1)+(OC1M*6),bitand(udpget(skt,"TIM1_CCMR2"),(65535-255)));  % mode 6 pwm, preload double buffer enable
  udpset(skt,"TIM1_CCMR2",TIM1_CCMR2_VAL);%configure the timer
endif

if (chan==4)%
%CCMR2_Output
  TIM1_CCMR2_VAL=bitor((OC2PE*1)+(OC2M*6),bitand(udpget(skt,"TIM1_CCMR2"),(255)));  % mode 6 pwm, preload double buffer enable
  udpset(skt,"TIM1_CCMR2",TIM1_CCMR2_VAL);%configure the timer
endif

% GPIOA alternative function 2 - output for TMR1 OC(chan)
%GPIOA_MODER_VAL=bitor(udpget(skt,"GPIOA_MODER"),(4^pin)*2);
%udpset(skt,"GPIOA_MODER",GPIOA_MODER_VAL);%configure the GPIOA pin

%GPIOA_AFR0_VAL=bitor(udpget(skt,"GPIOA_AFR0"),(16^pin)*2);
%udpset(skt,"GPIOA_AFR0",GPIOA_AFR0_VAL);%configure the GPIOB pin

%udpset(skt,"GPIOA_OSPEEDR",bitor(udpget(skt,"GPIOA_OSPEEDR"),(4^pin)*0));
udpset(skt,sprintf("TIM1_CCR%d",chan),high_period);%configure the pwm
udpset(skt,"TIM1_CCER",bitor(16^(chan-1),udpget(skt,"TIM1_CCER")));

udpset(skt,"TIM1_EGR",1);%configure the timer
TIM1_CR1_VAL=CEN+ARPE;
udpset(skt,"TIM1_CR1",TIM1_CR1_VAL); %configure the timer enable - clear all other CR1

%endfunction
